'use client';

import Image from 'next/image';
import Link from 'next/link';
import { useTranslations } from 'next-intl';

export default function LakeTokenFooter() {
  const t = useTranslations('LakeToken');
  return (
    <footer id="contact_us" className="w-full bg-[#002D64] relative flex flex-col items-center justify-end overflow-hidden">
      {/* Background Image */}
      <div className="absolute inset-0 w-full h-full">
        <Image
          src="/images/lake-token/body/Futer.svg"
          alt="Background"
          fill
          className="object-cover"
        />
      </div>
      
      {/* Контент футера */}
      <div className="relative z-10 w-full max-w-[1376px] flex flex-col justify-between items-start gap-16 px-4 py-12">
        {/* Contact us */}
        <div className="flex flex-col gap-8 max-w-[475px] w-full">
          <h2 className="font-inter text-[55.067px] font-bold text-white leading-[1.2] mb-2">{t('footer_contact_us')}</h2>
          <div className="flex flex-col gap-6">
            {/* Email */}
            <div className="flex items-center gap-3 w-full">
              <Image src="/images/lake-token/footer/Mask group - Footer 1.svg" alt="email" width={24} height={24} />
              <span className="font-inter text-[18px] text-white">investors@lakeresortresidence.com</span>
            </div>
            {/* Website */}
            <div className="flex items-center gap-3 w-full">
              <Image src="/images/lake-token/footer/Mask group - Footer 2.svg" alt="website" width={24} height={24} />
              <span className="font-inter text-[18px] text-white">www.lakeresortresidence.com</span>
            </div>
            {/* Smart Contract */}
            <div className="flex items-center gap-3 w-full">
              <Image src="/images/lake-token/footer/Mask group - Footer 3.svg" alt="contract" width={24} height={24} />
              <span className="font-inter text-[18px] text-white underline underline-offset-2">{t('footer_smart_contract')} <br/>0xa5706783e577b1a9a9a89502efb5387fedaec6e0</span>
            </div>
            {/* Inquiries */}
            <div className="flex items-center gap-3 w-full">
              <Image src="/images/lake-token/footer/Mask group - Footer 4.svg" alt="inquiries" width={24} height={24} />
              <a
                href="mailto:investors@lakeresortresidence.com"
                className="font-inter text-[18px] text-white underline hover:text-blue-200 transition-colors"
              >
                {t('footer_inquiries')}
              </a>
            </div>
          </div>
        </div>
        {/* Нижняя секция с Resources и подписью LAKE Token */}
        <div className="w-full flex items-end justify-between">
          {/* Resources */}
          <div className="flex flex-col gap-8 max-w-[516px] w-full">
            <h2 className="font-inter text-[55.067px] font-bold text-white leading-[1.2] mb-2">{t('footer_resources')}</h2>
            <div className="grid grid-cols-[auto_auto_1fr] gap-x-3 gap-y-6 items-center">
              {/* BscScan */}
              <Image src="/images/lake-token/footer/Mask group - BSCScan.svg" alt="bscscan" width={92} height={24} />
              <div className="w-6 h-6 flex items-center justify-center">
                <div className="w-2 h-2 bg-white rounded-full"></div>
              </div>
              <a
                href="https://bscscan.com/token/0xa5706783e577b1a9a9a89502efb5387fedaec6e0"
                target="_blank"
                rel="noopener noreferrer"
                className="font-inter text-[18px] text-white underline hover:text-blue-200 transition-colors"
              >
                {t('footer_bscscan')}
              </a>
              {/* Telegram */}
              <Image src="/images/lake-token/footer/Group 677 - Telegram.svg" alt="telegram" width={100} height={70} />
              <div className="w-6 h-6 flex items-center justify-center">
                <div className="w-2 h-2 bg-white rounded-full"></div>
              </div>
              <a
                href="https://t.me/lakeinvestorhub"
                target="_blank"
                rel="noopener noreferrer"
                className="font-inter text-[18px] text-white underline hover:text-blue-200 transition-colors"
              >
                {t('footer_telegram')}
              </a>
              {/* PDF */}
              <Image src="/images/lake-token/footer/LAKE Token.svg" alt="pdf" width={103} height={25} />
              <div className="w-6 h-6 flex items-center justify-center">
                <div className="w-2 h-2 bg-white rounded-full"></div>
              </div>
              <a
                href="https://github.com/LAKERESORTRESIDENCE/lake-token-whitepaper-md"
                target="_blank"
                rel="noopener noreferrer"
                className="font-inter text-[18px] text-white underline hover:text-blue-200 transition-colors"
              >
                {t('footer_pdf')}
              </a>
            </div>
          </div>
        </div>
        {/* Подпись и линия на всю ширину футера, выравнивание по левому краю блока Resources */}
        <div className="w-full flex items-center pt-8" style={{maxWidth: '1376px', margin: '0 auto', paddingLeft: '16px', paddingRight: '16px'}}>
          <span className="font-inter text-[30.075px] text-white opacity-80 tracking-[-1.804px]" style={{ fontWeight: 400, fontFamily: 'Inter', letterSpacing: '-1.804px' }}>
            <span style={{ fontFamily: 'Tilt Warp, sans-serif' }}>LAKE</span>{' '}
            <span style={{ fontFamily: 'Inter, sans-serif' }}>Token</span>
          </span>
          <div className="h-0 border-t-2 border-white ml-8 flex-1" />
        </div>
      </div>
    </footer>
  );
} 